/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.soul;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class ItemMonsterSoul
extends Item
implements IDemonWill {
    private final EnumDemonWillType type;

    public ItemMonsterSoul(EnumDemonWillType type) {
        super(new Item.Properties().m_41487_(1).m_41491_(BloodMagic.TAB));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.will", new Object[]{ChatUtil.DECIMAL_FORMAT.format(this.getWill(this.getType(stack), stack))}).m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, world, tooltip, flag);
    }

    @Override
    public EnumDemonWillType getType(ItemStack stack) {
        return this.type;
    }

    @Override
    public double getWill(EnumDemonWillType type, ItemStack soulStack) {
        if (type != this.getType(soulStack)) {
            return 0.0;
        }
        NBTHelper.checkNBT(soulStack);
        CompoundTag tag = soulStack.m_41783_();
        return tag.m_128459_("souls");
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            this.setWill(this.type, stack, 5.0);
            items.add((Object)stack);
        }
    }

    @Override
    public boolean setWill(EnumDemonWillType type, ItemStack soulStack, double souls) {
        if (type != this.getType(soulStack)) {
            return false;
        }
        NBTHelper.checkNBT(soulStack);
        CompoundTag tag = soulStack.m_41783_();
        tag.m_128347_("souls", souls);
        return true;
    }

    @Override
    public double drainWill(EnumDemonWillType type, ItemStack soulStack, double drainAmount) {
        double souls = this.getWill(type, soulStack);
        double soulsDrained = Math.min(drainAmount, souls);
        this.setWill(type, soulStack, souls - soulsDrained);
        return soulsDrained;
    }

    @Override
    public ItemStack createWill(double number) {
        ItemStack soulStack = new ItemStack((ItemLike)this);
        this.setWill(this.getType(soulStack), soulStack, number);
        return soulStack;
    }
}

